/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.guns;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.IReloadManager;
import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.client.render.RenderConfigs;
import dev.toma.gunsrpg.client.render.item.R45Renderer;
import dev.toma.gunsrpg.common.attribute.Attribs;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.entity.projectile.AbstractProjectile;
import dev.toma.gunsrpg.common.init.ModSounds;
import dev.toma.gunsrpg.common.init.Skills;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.common.item.guns.ammo.AmmoMaterials;
import dev.toma.gunsrpg.common.item.guns.ammo.AmmoType;
import dev.toma.gunsrpg.common.item.guns.reload.ReloadManagers;
import dev.toma.gunsrpg.common.item.guns.setup.WeaponBuilder;
import dev.toma.gunsrpg.common.item.guns.setup.WeaponCategory;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.util.SkillUtil;
import dev.toma.gunsrpg.util.properties.Properties;
import lib.toma.animations.api.IRenderConfig;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class R45Item
extends GunItem {
    private static final ResourceLocation AIM = GunsRPG.makeResource("r45/aim");
    private static final ResourceLocation RELOAD = GunsRPG.makeResource("r45/reload");
    private static final ResourceLocation RELOAD_BULLET = GunsRPG.makeResource("r45/load_bullet");
    private static final ResourceLocation UNJAM = GunsRPG.makeResource("r45/unjam");

    public R45Item(String name) {
        super(name, new Item.Properties().setISTER(() -> R45Renderer::new).func_200918_c(350));
    }

    @Override
    public void initializeWeapon(WeaponBuilder builder) {
        builder.config(GunsRPG.config.weapon.r45).caliber(AmmoType.AMMO_45ACP).ammo(WeaponCategory.PISTOL).define(AmmoMaterials.WOOD, 0).define(AmmoMaterials.STONE, 2).define(AmmoMaterials.IRON, 4).define(AmmoMaterials.LAPIS, 3).define(AmmoMaterials.GOLD, 6).define(AmmoMaterials.REDSTONE, 5).define(AmmoMaterials.EMERALD, 9).define(AmmoMaterials.QUARTZ, 7).define(AmmoMaterials.DIAMOND, 11).define(AmmoMaterials.AMETHYST, 14).define(AmmoMaterials.NETHERITE, 17).build();
    }

    @Override
    public int getFirerate(IAttributeProvider provider) {
        return provider.getAttribute(Attribs.R45_FIRERATE).intValue();
    }

    @Override
    protected boolean isSilenced(PlayerEntity player) {
        return PlayerData.hasActiveSkill(player, Skills.R45_SUPPRESSOR);
    }

    @Override
    protected SoundEvent getShootSound(PlayerEntity entity) {
        return this.isSilenced(entity) ? ModSounds.GUN_R1895_SILENCED : ModSounds.GUN_R45;
    }

    @Override
    public int getUnjamTime(ItemStack stack) {
        return 60;
    }

    @Override
    public int getMaxAmmo(IAttributeProvider provider) {
        return provider.getAttribute(Attribs.R45_MAG_CAPACITY).intValue();
    }

    @Override
    public int getReloadTime(IAttributeProvider provider, ItemStack stack) {
        return Attribs.R45_RELOAD.intValue(provider);
    }

    @Override
    public float getVerticalRecoil(IAttributeProvider provider) {
        return Attribs.R45_VERTICAL.floatValue(provider);
    }

    @Override
    public float getHorizontalRecoil(IAttributeProvider provider) {
        return Attribs.R45_HORIZONTAL.floatValue(provider);
    }

    @Override
    public double getNoiseMultiplier(IAttributeProvider provider) {
        return Attribs.R45_LOUDNESS.value(provider);
    }

    @Override
    public void onHitEntity(AbstractProjectile bullet, LivingEntity victim, ItemStack stack, LivingEntity shooter) {
        this.handleHeadshotHealing(bullet, shooter);
    }

    @Override
    public void onKillEntity(AbstractProjectile bullet, LivingEntity victim, ItemStack stack, LivingEntity shooter) {
        this.handleHeadshotHealing(bullet, shooter);
    }

    @Override
    public float modifyProjectileDamage(AbstractProjectile projectile, LivingEntity entity, PlayerEntity shooter, float damage) {
        float healthStatus;
        if (PlayerData.hasActiveSkill(shooter, Skills.R45_COLD_BLOODED) && (healthStatus = entity.func_110143_aJ() / entity.func_110138_aP()) == 1.0f) {
            return damage * 1.3f;
        }
        return damage;
    }

    @Override
    public IReloadManager getReloadManager(PlayerEntity player, IAttributeProvider attributeProvider) {
        return ReloadManagers.singleBulletLoading(26, player, this, player.func_184614_ca(), RELOAD_BULLET);
    }

    @Override
    public SkillType<?> getRequiredSkill() {
        return Skills.R45_ASSEMBLY;
    }

    @Override
    public ResourceLocation getReloadAnimation(PlayerEntity player) {
        return RELOAD;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getUnjamAnimationPath() {
        return UNJAM;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getAimAnimationPath(ItemStack stack, PlayerEntity player) {
        return AIM;
    }

    @Override
    public IRenderConfig left() {
        return RenderConfigs.R45_LEFT;
    }

    @Override
    public IRenderConfig right() {
        return RenderConfigs.R45_RIGHT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onShoot(PlayerEntity player, ItemStack stack) {
    }

    private void handleHeadshotHealing(AbstractProjectile projectile, LivingEntity shooter) {
        boolean headshot;
        if (!(shooter instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)shooter;
        if (PlayerData.hasActiveSkill(player, Skills.R45_ACE_OF_HEARTS) && (headshot = projectile.getProperty(Properties.IS_HEADSHOT).booleanValue())) {
            SkillUtil.heal(player, 1.0f);
        }
    }
}

